program Serial_receiver;

uses
Crt,Dos,Memory;

var
Asp:pointer;
Out:file;
PS:word;
Int8:string[4];
FileName:string[64];
i:word;
chrx:byte;
ErrorByte:integer;
The_Maxximum,CheckSum,CheckSum2,WaitRate:word;
CheckState:byte;
ActualChunk:word;

procedure FatalError;
begin
     writeln('Error:Cannot open ',FileName,' for output.');
     halt;
end;

begin
      FileName:=ParamStr(1);
      if (ParamStr(1)='') or (ParamStr(1)='/?') then begin
         writeln('REC');
         writeln('---');
         writeln('Usage:REC Output file [Wait rate]');
         writeln('');
         writeln('Receives a binary file from an ENTERPRISE serial port.');
         writeln('Default wait rate is 200 for i486SX25');
         writeln('');
         writeln('Data Transfer Rate:10 kBaud');
         writeln('Maximum chunk size:256 bytes');
         writeln('Safety            :16 bits checksum/chunk');
         writeln('Max.file size     :About 32M...');
         writeln('');
         writeln('By Exosworm Digital Corp.1994');
         halt;
      end;
      if ParamStr(2)='' then WaitRate:=200 else Val(ParamStr(2),WaitRate,ErrorByte);
      Assign(Out,FileName);
      if IOresult<>0 then FatalError;
      Rewrite(out,1);
      if IOresult<>0 then FatalError;
      if MemAvail<80000 then begin
         writeln('Error:Not enough free conventional memory.');
         halt;
      end;
      ClrScr;
      TextColor(3);
      writeln('Serial RX software for ENTERPRISE-PC connection - version 1.0');
      TextColor(4);
      writeln('');
      TextColor(5);
      writeln('Click on the "Start  transmitting" text on your EP,then press');
      writeln('any key on your PC.');
      repeat until keypressed;
      writeln('Press SPACE on your EP to begin transferring...');
      TextColor(6);
      writeln('Chunk:');
      Asp:=MemAllocSeg($fff0);
      ActualChunk:=0;
      repeat
      asm
          mov ax,word ptr [Asp+2]
          mov word ptr [PS],ax
          mov word ptr cs:[@PfSg+1],ax
          cli

          mov dx,2f8h+6
@signal:  in al,dx
          and al,16
          jz @signal

          xor ax,ax
          mov es,ax
          mov ax,word ptr es:[20h]
          mov bx,word ptr es:[22h]
          mov word ptr [Int8],ax
          mov word ptr [Int8+2],bx

          mov word ptr es:[22h],cs
          mov ax,offset @IT
          mov word ptr es:[20h],ax

          mov al,36h              {10 kHz INTERRUPT at INT 8}
          out 43h,al
          mov al,119
          out 40h,al
          xor al,al
          out 40h,al

          xor ax,ax
          inc ax
          mov word ptr cs:[@memo+1],ax

          mov cx,word ptr [WaitRate]   {Wait for first data bit - 200 for i486SX25 8k Cache}
@waix:    loop @waix
          sti

@watch:   mov ax,word ptr cs:[@memo+1]
          cmp ax,2088
          jc @watch

          cli
          mov es,word ptr [PS]
          xor si,si
          mov di,1000h
          mov cx,261
@exter:   push cx
          mov cx,8
@inter:   cmp byte ptr es:[si],16
          cmc
          rcr bx,1
          inc si
          loop @inter
          pop cx
          mov es:[di],bh
          inc di
          loop @exter

          xor ax,ax
          mov es,ax
          mov ax,word ptr [Int8]
          mov bx,word ptr [Int8+2]
          mov word ptr es:[20h],ax
          mov word ptr es:[22h],bx
          mov al,36h
          out 43h,al
          xor al,al
          out 40h,al
          out 40h,al
          sti
          jmp @exxit

@IT:      push ax
          push dx
          push si
          push es
@PfSg:    mov ax,0
          mov es,ax
          mov dx,2f8h+6
          in al,dx
          and al,16

@memo:    mov si,1
          mov byte ptr es:[si],al
          inc si
          mov word ptr cs:[@memo+1],si
          mov al,20h
          out 20h,al
          pop es
          pop si
          pop dx
          pop ax
          iret
@exxit:
         mov es,word ptr [PS]
         mov ax,word ptr es:[1001h]
         mov word ptr [The_Maxximum],ax
         mov cx,ax
         xor bl,bl
         or cx,cx
         jz @same
         mov ax,word ptr es:[1003h]
         mov word ptr [CheckSum2],ax
         mov si,1005h
         mov ax,8080h
@check:  add al,es:[si]
         xor ah,es:[si]
         inc si
         loop @check
         xor bl,bl
         mov word ptr [CheckSum],ax
         cmp ax,word ptr es:[1003h]
         jz @same
         dec bl
@same:   mov byte ptr [CheckState],bl
         push 0b800h
         pop es
         mov ax,word ptr [ActualChunk]
         inc ax
         mov word ptr [ActualChunk],ax
      end;

      if CheckState=255 then begin
         writeln('Checksum error:',CheckSum,' instead of ',CheckSum2,',Chunk size:',The_Maxximum);
         close(out);
         halt;
      end;

      if The_Maxximum<>0 then begin
         for i:=0 to The_Maxximum-1 do begin
         asm
            mov bx,word ptr [i]
            mov es,word ptr [PS]
            mov si,1005h
            mov al,es:[si+bx]
            mov byte ptr [chrx],al
         end;
         BlockWrite(Out,chrx,1,ErrorByte);
         end;
      end;
      GotoXY(7,6);
      writeln(ActualChunk shr 2,'k');
until The_Maxximum<256;

TextColor(2);
writeln('Transfer ok,no error.');
writeln('REC by Exosworm Digital Corp.1994');
close(out);
end.